
/*! \file CE2_basetypes.h
\brief This file contains base types definitions
*/


#ifndef _CE2_BASETYPES_H
#define _CE2_BASETYPES_H

#define DX_NULL 		0

typedef unsigned char        	DxUint8_t;

typedef unsigned short       	DxUint16_t;

typedef unsigned long        	DxUint32_t;

/* #if defined(__ARMCC_VERSION) || defined(__SYMBIAN32__) */
#ifdef HASLONGLONG
typedef unsigned long long		DxUint64_t;
#elif defined(HAS_INT64)
typedef unsigned _int64			DxUint64_t;
#else
typedef unsigned __int64	DxUint64_t;
#endif

typedef signed char	          	DxInt8_t;

typedef char                DxChar;

typedef signed short         	DxInt16_t;

typedef signed long          	DxInt32_t;

typedef unsigned int       		DxUint_t;

typedef signed int            	DxInt_t;

typedef enum{
  FALSE = 0,
  TRUE = 1
}EcDxBool_t;


typedef unsigned long 		DxStatus;


/* only for backward compatibility */
/*            ||                   */
/*            ||                   */
/*            \/                   */


//typedef unsigned int DxSize_t;
typedef DxUint32_t   DxVosResult_t; 

#define DX_SUCCESS			0UL 


#ifdef DX_VOS_LEGACY_BASETYPES_SUPPORT

#define NULL 				0

typedef DxUint8_t         uint8_t;

typedef DxUint16_t        uint16_t;

typedef DxUint32_t        uint32_t;

typedef DxUint64_t		  uint64_t;

typedef DxInt8_t          int8_t;

typedef DxInt16_t         int16_t;

typedef DxInt32_t         int32_t;



#ifndef FALSE
#define FALSE  0
#endif

#ifndef TRUE
#define TRUE   1
#endif

#endif	/* DX_LEGACY_BASETYPES_SUPPOR */

#endif /* ifndef CE2__BASETYPES_H */




